<?php

    if (!defined("APP_SIGNATURE")) {

        header("Location: /");
        exit;
    }

    if (!auth::isSession()) {

        header("Location: /");
        exit;
    }

    if (auth::getCurrentUserId() == 0) {

        header("Location: /");
        exit;
    }

    require('sys/addons/vendor/autoload.php');

    \Stripe\Stripe::setVerifySslCerts(false);
    \Stripe\Stripe::setApiKey(STRIPE_SECRET_KEY);

    if (!empty($_POST)) {

        $packageId = isset($_POST['packageId']) ? $_POST['packageId'] : 0;

        $result = array(
            "error" => true,
            "error_code" => ERROR_UNKNOWN
        );

        if ($packageId < count($payments_packages)) {

            $product = \Stripe\Product::create([
                'name' => $payments_packages[$packageId]['name'],
                'description' => $payments_packages[$packageId]['name']
            ]);

            $price = \Stripe\Price::create([
                'product' => $product->id,
                'unit_amount' => $payments_packages[$packageId]['amount'],
                'currency' => 'usd',
            ]);

            $session = \Stripe\Checkout\Session::create([
                'payment_method_types' => ['card'],
                'line_items' => [[
                    'price' => $price->id,
                    'quantity' => 1
                ]],
                'mode' => 'payment',
                'success_url' => APP_URL.'/account/balance?session_id={CHECKOUT_SESSION_ID}',
                'cancel_url' => APP_URL.'/account/balance',
            ]);

            $stripeSession = array($session);
            $sessId = ($stripeSession[0]['id']);

            $_SESSION['sessId'] = $sessId;
            $_SESSION['packageId'] = $packageId;

            $result = array(
                "error" => false,
                "error_code" => ERROR_SUCCESS,
                "sessId" => $sessId
            );
        }

        echo json_encode($result);
        exit;
    }

    $payment = false;

    if (isset($_GET['session_id'])) {

        try {

            $response = \Stripe\Checkout\Session::retrieve($_GET['session_id']);

            if (isset($_SESSION['sessId'])) {

                $paymentIntent = \Stripe\PaymentIntent::retrieve($response['payment_intent']);

                if ($_GET['session_id'] == $_SESSION['sessId']) {

                    $account = new account($dbo, auth::getCurrentUserId());
                    $account->setBalance($account->getBalance() + $payments_packages[$_SESSION['packageId']]['credits']);

                    $payments = new payments($dbo);
                    $payments->setRequestFrom(auth::getCurrentUserId());
                    $payments->create(PA_BUY_CREDITS, PT_CARD, $payments_packages[$_SESSION['packageId']]['credits'], $payments_packages[$_SESSION['packageId']]['amount']);
                    unset($payments);

                    unset($_SESSION['sessId']);
                    unset($_SESSION['packageId']);

                    $fcm = new fcm($dbo);
                    $fcm->setRequestFrom(auth::getCurrentUserId());
                    $fcm->setRequestTo(auth::getCurrentUserId());
                    $fcm->setType(GCM_NOTIFY_CHANGE_ACCOUNT_SETTINGS);
                    $fcm->setTitle("You settings is changed.");
                    $fcm->prepare();
                    $fcm->send();
                    unset($fcm);

                    $payment = true;
                }
            }

        } catch (\Stripe\Exception\ApiErrorException $e) {

            $payment = false;
        }
    }

    //

    $settings = new settings($dbo);
    $config = $settings->get();
    unset($settings);

    //

    $account = new account($dbo, auth::getCurrentUserId());

    $page_id = "balance";

    $css_files = array("main.css", "my.css");
    $page_title = $LANG['page-balance']." | ".APP_TITLE;

    include_once("html/common/site_header.inc.php");

?>

<body class="settings-page">

<?php

    include_once("html/common/site_topbar.inc.php");
?>

<div class="wrap content-page">

    <div class="main-column row">

        <?php

            include_once("html/common/site_sidenav.inc.php");
        ?>

        <div class="col-lg-9 col-md-12" id="content">

            <div class="main-content">

                <div class="standard-page">

                    <h1><?php echo $LANG['page-balance']; ?></h1>

                    <div class="tab-container">
                        <nav class="tabs">
                            <a href="/account/settings"><span class="tab"><?php echo $LANG['page-profile-settings']; ?></span></a>
                            <a href="/account/settings/privacy"><span class="tab"><?php echo $LANG['page-privacy-settings']; ?></span></a>
                            <a href="/account/balance"><span class="tab active"><?php echo $LANG['page-balance']; ?></span></a>
                            <a href="/account/settings/services"><span class="tab"><?php echo $LANG['label-services']; ?></span></a>
                            <a href="/account/settings/password"><span class="tab"><?php echo $LANG['label-password']; ?></span></a>
                            <a href="/account/settings/referrals"><span class="tab"><?php echo $LANG['page-referrals']; ?></span></a>
                            <a href="/account/settings/blacklist"><span class="tab"><?php echo $LANG['page-blacklist']; ?></span></a>
                            <a href="/account/settings/deactivation"><span class="tab"><?php echo $LANG['page-deactivate-account']; ?></span></a>
                        </nav>
                    </div>

                    <?php

                    if ($payment) {

                        ?>

                        <div class="success-container" style="margin-top: 15px;">
                            <ul class="m-0">
                                <b><?php echo $LANG['label-thanks']; ?></b>
                                <br>
                                <?php echo $LANG['label-payments-success_added']; ?>
                            </ul>
                        </div>

                        <?php
                    }
                    ?>

                    <header class="top-banner px-0">

                        <div class="info">
                            <h1><?php echo $LANG['page-balance']; ?></h1>
                            <p><?php echo $LANG['page-balance-desc'] ?></p>
                            <p><?php echo $LANG['label-balance']; ?> <b><?php echo $account->getBalance(); ?> <?php echo $LANG['label-credits']; ?></b></p>
                        </div>

                    </header>

                    <?php

                        if (APP_DEMO) {

                            ?>

                            <div class="warning-container d-block col-12">
                                <p class="m-0">
                                    <span><b>For testing:</b></span>
                                    <span class="d-block">Use card number for test: 4242424242424242</span>
                                    <span class="d-block">CVC and other data: any</span>
                                </p>
                            </div>

                            <?php
                        }
                    ?>

                    <header class="top-banner p-0">
                        <div class="info">
                            <h1><?php echo $LANG['action-buy-credits-stripe']; ?></h1>
                        </div>
                    </header>

                    <div class="row col-12 px-0">

                    <?php

                        foreach ($payments_packages as $package) {

                            ?>
                            <div class="col-12 col-sm-12 col-md-4 col-lg-4 mt-2 p-0">

                                <a class="stripe-buy-button button primary d-block mx-2" onclick="Payments.new(<?php echo $package['id']; ?>); return false;" href="javascript: void(0)"><i class="icofont icofont-stripe-alt"></i> <?php echo $package['name']." ".$LANG['label-payments-for']." $".$package['amount'] / 100; ?></a>
                            </div>

                            <?php
                        }
                    ?>
                    </div>

                    <!-- PayPal -->

                    <?php

                        if ($config['paypal_enabled']['intValue'] == 1) {

                            ?>

                                <header class="top-banner p-0">
                                    <div class="info mt-2">
                                        <h1><?php echo $LANG['action-buy-credits-paypal']." (".$config['paypal_count']['intValue']." credits for ".$config['paypal_price']['intValue']." ".$config['paypal_currency']['textValue'].")"; ?></h1>
                                    </div>
                                </header>

                                <div class="paypay-loader hidden" style="display: block; height: 100px; position: relative;">
                                    <span class="card-loader-container">
                                        <div class="loader"><i class="ic icon-spin icon-spin"></i></div>
                                    </span>
                                </div>

                                <div id="paypal-button-container" class="row col-12 px-0"></div>

                            <?php
                        }
                    ?>

                    <!-- History -->

                    <header class="top-banner px-0 pb-0">
                        <div class="info">
                            <h1><?php echo $LANG['label-payments-history']; ?></h1>
                        </div>
                    </header>

                    <div class="listview">
                        <table class="bordered data-tables responsive-table">
                            <tbody>
                            <tr class="listview-header">
                                <th class="text-center"><?php echo $LANG['label-payments-credits']; ?></th>
                                <th class="text-center"><?php echo $LANG['label-payments-amount']; ?></th>
                                <th class="text-right"><?php echo $LANG['label-payments-description']; ?></th>
                                <th class="text-right"><?php echo $LANG['label-payments-date']; ?></th>
                            </tr>

                            <?php

                            $payments = new payments($dbo);
                            $payments->setRequestFrom(auth::getCurrentUserId());

                            $result = $payments->get(0, 30);

                            if (count($result['items']) == 0) {

                                ?>

                                <tr>
                                    <td colspan="5" class="text-center">
                                        <div class="card information-banner border-0 shadow-none m-0">
                                            <div class="card-header border-0">
                                                <div class="card-body">
                                                    <h5 class="m-0"><?php echo $LANG['label-empty-list']; ?></h5>
                                                </div>
                                            </div>
                                        </div>
                                    </td>
                                </tr>

                                <?php

                            } else {

                                foreach ($result['items'] as $key => $value) {

                                    ?>

                                    <tr>
                                        <td class="text-center">
                                            <?php
                                            switch ($value['paymentAction']) {

                                                case PA_BUY_CREDITS: {

                                                    echo "<span class=\"green\">+".$value['credits']."</span>";
                                                    break;
                                                }

                                                case PA_BUY_REGISTRATION_BONUS: {

                                                    echo "<span class=\"green\">+".$value['credits']."</span>";
                                                    break;
                                                }

                                                case PA_BUY_REFERRAL_BONUS: {

                                                    echo "<span class=\"green\">+".$value['credits']."</span>";
                                                    break;
                                                }

                                                default: {

                                                    echo "<span class=\"red\">-".$value['credits']."</span>";
                                                    break;
                                                }
                                            }
                                            ?>
                                        </td>
                                        <td class="text-center">
                                            <?php
                                            switch ($value['paymentAction']) {

                                                case PA_BUY_CREDITS: {

                                                    if ($value['amount'] > 0) {

                                                        if ($value['paymentType'] == PT_PAYPAL) {

                                                            echo "$".$value['amount'];

                                                        } else {

                                                            echo "$".$value['amount'] / 100;
                                                        }

                                                        break;
                                                    }
                                                }

                                                default: {

                                                    echo "";
                                                    break;
                                                }
                                            }
                                            ?>
                                        </td>
                                        <td class="text-right" style="word-break: break-word">
                                            <?php
                                            switch ($value['paymentAction']) {

                                                case PA_BUY_CREDITS: {

                                                    switch ($value['paymentType']) {

                                                        case PT_CARD: {

                                                            echo $LANG['label-payments-credits-stripe'];
                                                            break;
                                                        }

                                                        case PT_PAYPAL: {

                                                            echo $LANG['label-payments-credits-stripe'];
                                                            break;
                                                        }

                                                        case PT_GOOGLE_PURCHASE: {

                                                            echo $LANG['label-payments-credits-android'];
                                                            break;
                                                        }

                                                        case PT_APPLE_PURCHASE: {

                                                            echo $LANG['label-payments-credits-ios'];
                                                            break;
                                                        }

                                                        case PT_ADMOB_REWARDED_ADS: {

                                                            echo $LANG['label-payments-credits-admob'];
                                                            break;
                                                        }
                                                    }

                                                    break;
                                                }

                                                case PA_BUY_GIFT: {

                                                    echo $LANG['label-payments-send-gift'];
                                                    break;
                                                }

                                                case PA_BUY_VERIFIED_BADGE: {

                                                    echo $LANG['label-payments-verified-badge'];
                                                    break;
                                                }

                                                case PA_BUY_GHOST_MODE: {

                                                    echo $LANG['label-payments-ghost-mode'];
                                                    break;
                                                }

                                                case PA_BUY_PRO_MODE: {

                                                    echo $LANG['label-payments-pro-mode'];
                                                    break;
                                                }

                                                case PA_BUY_MESSAGE_PACKAGE: {

                                                    echo $LANG['label-payments-message-package'];
                                                    break;
                                                }

                                                case PA_BUY_SPOTLIGHT: {

                                                    echo $LANG['label-payments-spotlight-feature'];
                                                    break;
                                                }

                                                case PA_BUY_DISABLE_ADS: {

                                                    echo $LANG['label-payments-off-admob'];
                                                    break;
                                                }

                                                case PA_BUY_REGISTRATION_BONUS: {

                                                    echo $LANG['label-payments-registration-bonus'];
                                                    break;
                                                }

                                                case PA_BUY_REFERRAL_BONUS: {

                                                    echo $LANG['label-payments-referral-bonus'];
                                                    break;
                                                }
                                            }
                                            ?>
                                        </td>
                                        <td class="text-right"><?php echo $value['date']; ?></td>
                                    </tr>

                                    <?php
                                }
                            }

                            ?>

                            </tbody>
                        </table>
                    </div>

                </div>

            </div>
        </div>
    </div>

</div>


    <script src="https://js.stripe.com/v3/"></script>

<?php

    include_once("html/common/site_footer.inc.php");

?>

<?php

    if ($config['paypal_enabled']['intValue'] == 1) {

        ?>
            <script src="https://www.paypal.com/sdk/js?client-id=<?php echo $config['paypal_client_id']['textValue']; ?>" ></script>

            <script>

                var credits = <?php echo $config['paypal_count']['intValue']; ?>;
                var amount = <?php echo $config['paypal_price']['intValue']; ?>;
                var paymentType = <?php echo PT_PAYPAL; ?>;

                function initPayPalButton() {
                    paypal
                        .Buttons({
                            style: {
                                shape: "rect",
                                color: "gold",
                                layout: "vertical",
                                label: "pay",
                                height: 33,
                                borderRadius: 3,
                                disableMaxWidth: true,
                            },

                            createOrder: function (data, actions) {

                                return actions.order.create({
                                    purchase_units: [
                                        { amount: { currency_code: "<?php echo $config['paypal_currency']['textValue']; ?>", value: <?php echo $config['paypal_price']['intValue']; ?> } },
                                    ],
                                });
                            },

                            onApprove: function (data, actions) {

                                return actions.order.capture().then(function (orderData) {

                                    // Full available details
                                    console.log(
                                        "Capture result",
                                        orderData,
                                        JSON.stringify(orderData, null, 2)
                                    );

                                    // Show a success message within this page, for example:
                                    const element = document.getElementById("paypal-button-container");
                                    element.innerHTML = "";

                                    $('div.paypay-loader').removeClass('hidden');

                                    $.ajax({
                                        type: 'POST',
                                        url: '/api/' + options.api_version + '/method/payments.new',
                                        data: "accessToken=" + account.accessToken + "&accountId=" + account.id + "&credits=" + credits + "&paymentType=" + paymentType + "&amount=" + amount,
                                        dataType: 'json',
                                        timeout: 30000,
                                        success: function(response){

                                            location.reload();
                                        },
                                        error: function(xhr, type){

                                            location.reload();
                                        }
                                    });
                                });
                            },

                            onError: function (err) {
                                console.log(err);
                            },
                        })
                        .render("#paypal-button-container");
                }

                initPayPalButton();

            </script>
        <?php
    }
?>

<script>

    //set your publishable key
    var stripe = Stripe('<?php echo STRIPE_PUBLISHABLE_KEY; ?>');

    window.Payments || ( window.Payments = {} );

    Payments.new = function (package_id) {

        $.ajax({
            type: 'POST',
            url: '/account/balance',
            data: "packageId=" + package_id,
            dataType: 'json',
            timeout: 30000,
            success: function(response){

                if (response.hasOwnProperty('error')) {

                    if (response.error === false) {

                        if (response.hasOwnProperty('sessId')) {

                            stripe.redirectToCheckout({
                                // Make the id field from the Checkout Session creation API response
                                // available to this file, so you can provide it as parameter here
                                // instead of the {{CHECKOUT_SESSION_ID}} placeholder.
                                sessionId: response.sessId
                            }).then(function (result) {
                                // If `redirectToCheckout` fails due to a browser or network
                                // error, display the localized error message to your customer
                                // using `result.error.message`.
                            });
                        }
                    }
                }
            },
            error: function(xhr, type){


            }
        });
    };

    $('.btn-stripe').click(function() {

        Payments.new(1);
    });

</script>

</body>
</html>